<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


if ( ! function_exists( 'couponwp_filetype_and_ext' ) ) {
    /**
     * Allow upload csv file
     *
     * @see wp_check_filetype_and_ext
     *
     * @param array $check
     * @param string $file
     * @param bool|false $file_name
     * @param bool|false $mimes
     * @return array
     */
    function couponwp_filetype_and_ext($check = array(), $file = '', $file_name = false, $mimes = false)
    {

        $dots = explode('.', $file_name);
        $ext = end($dots);
        if (strtolower($ext) == 'csv') {
            $check['ext'] = 'csv';
            $check['type'] = 'text/csv';
            $check['proper_filename'] = $file_name;
        }

        return $check;

    }
    add_filter( 'wp_check_filetype_and_ext', 'couponwp_filetype_and_ext',35, 4 );
}


if ( ! function_exists( 'wp_handle_upload' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
}
if ( isset( $_FILES['wp_coupon_import_file'] ) ) {
    $uploadedfile = $_FILES['wp_coupon_import_file'];
    $upload_overrides = array( 'test_form' => false );
    $movefile = wp_handle_upload( $uploadedfile, $upload_overrides );

    if ( $movefile && ! isset( $movefile['error'] ) ) {


        $attchment_id = wp_insert_attachment(
            array(
                'post_mime_type' => $movefile['type'],
                'guid'           => $movefile['url'],
                'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $movefile['url'] ) ),
            ),
            $movefile['file']
        );

        if ( $attchment_id && ! is_wp_error( $attchment_id ) ) {
            $GLOBALS['wp_coupon_import'] = array(
                'msg' =>  esc_html__( "File is valid, and was successfully uploaded.", 'wp_coupon_ie' ),
                'uploaded' => $movefile,
                'attchment_id' => $attchment_id,
                'sucsess' => true
            );
        } else {
            if ( is_file( $movefile['file'] ) ) {
                unlink( $movefile['file']  );
            }
            $GLOBALS['wp_coupon_ie'] = array(
                'msg' =>   esc_html__( "Could not save upload file.", 'wp_coupon_ie' ),
                'sucsess' => false
            );
        }

        require WP_COUPON_IE_PATH.'vendor/autoload.php';


        $inputFileName = $movefile['file'];

        /** Load $inputFileName to a Spreadsheet Object  **/
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileName);

        $worksheet = $spreadsheet->getActiveSheet();
        $rows = $worksheet->toArray();

        $all_rows = array();
        $header = null;

        while ( $row = current( $rows ) ) {
            if ( $header === null) {
                $header = $row;
            } else {
                $all_rows[] = array_combine($header, $row);
            }
            next( $rows );
        }

         $_SESSION['wp_coupon_import_data'] = $all_rows;
         $_SESSION['wp_coupon_imported_data'] = false;

    } else {
        /**
         * Error generated by _wp_handle_upload()
         * @see _wp_handle_upload() in wp-admin/includes/file.php
         */
        $GLOBALS['wp_coupon_import'] = array(
            'error' =>  $movefile['error'],
            'msg' =>   esc_html__( "Could not upload file.", 'wp_coupon_ie' ),
            'sucsess' => false
        );
    }
}
