
<script type="text/template" id="tmpl-et-studio-logo">
    <span class="et-studio-logo-img or et-studio-icon">
        <svg width="261" height="40" viewBox="0 0 327 50" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
			<path d="M52.236 15.611C52.11 15.821 51.97 15.982 51.816 16.094C51.676 16.192 51.501 16.241 51.291 16.241C51.053 16.241 50.773 16.122 50.451 15.884C50.129 15.646 49.723 15.387 49.233 15.107C48.757 14.813 48.176 14.547 47.49 14.309C46.818 14.071 45.999 13.952 45.033 13.952C44.123 13.952 43.318 14.078 42.618 14.33C41.932 14.568 41.351 14.897 40.875 15.317C40.413 15.737 40.063 16.234 39.825 16.808C39.587 17.368 39.468 17.977 39.468 18.635C39.468 19.475 39.671 20.175 40.077 20.735C40.497 21.281 41.043 21.75 41.715 22.142C42.401 22.534 43.171 22.877 44.025 23.171C44.893 23.451 45.775 23.745 46.671 24.053C47.581 24.361 48.463 24.711 49.317 25.103C50.185 25.481 50.955 25.964 51.627 26.552C52.313 27.14 52.859 27.861 53.265 28.715C53.685 29.569 53.895 30.619 53.895 31.865C53.895 33.181 53.671 34.42 53.223 35.582C52.775 36.73 52.117 37.731 51.249 38.585C50.395 39.439 49.338 40.111 48.078 40.601C46.832 41.091 45.411 41.336 43.815 41.336C41.855 41.336 40.077 40.986 38.481 40.286C36.885 39.572 35.52 38.613 34.386 37.409L35.562 35.477C35.674 35.323 35.807 35.197 35.961 35.099C36.129 34.987 36.311 34.931 36.507 34.931C36.689 34.931 36.892 35.008 37.116 35.162C37.354 35.302 37.62 35.484 37.914 35.708C38.208 35.932 38.544 36.177 38.922 36.443C39.3 36.709 39.727 36.954 40.203 37.178C40.693 37.402 41.246 37.591 41.862 37.745C42.478 37.885 43.171 37.955 43.941 37.955C44.907 37.955 45.768 37.822 46.524 37.556C47.28 37.29 47.917 36.919 48.435 36.443C48.967 35.953 49.373 35.372 49.653 34.7C49.933 34.028 50.073 33.279 50.073 32.453C50.073 31.543 49.863 30.801 49.443 30.227C49.037 29.639 48.498 29.149 47.826 28.757C47.154 28.365 46.384 28.036 45.516 27.77C44.648 27.49 43.766 27.21 42.87 26.93C41.974 26.636 41.092 26.3 40.224 25.922C39.356 25.544 38.586 25.054 37.914 24.452C37.242 23.85 36.696 23.101 36.276 22.205C35.87 21.295 35.667 20.175 35.667 18.845C35.667 17.781 35.87 16.752 36.276 15.758C36.696 14.764 37.298 13.882 38.082 13.112C38.88 12.342 39.853 11.726 41.001 11.264C42.163 10.802 43.493 10.571 44.991 10.571C46.671 10.571 48.197 10.837 49.569 11.369C50.955 11.901 52.173 12.671 53.223 13.679L52.236 15.611ZM79.9967 14.33H70.2527V41H66.1997V14.33H56.4347V10.907H79.9967V14.33ZM110.913 25.964C110.913 28.218 110.556 30.29 109.842 32.18C109.128 34.056 108.12 35.673 106.818 37.031C105.516 38.389 103.948 39.446 102.114 40.202C100.294 40.944 98.2776 41.315 96.0656 41.315C93.8536 41.315 91.8376 40.944 90.0176 40.202C88.1976 39.446 86.6366 38.389 85.3346 37.031C84.0326 35.673 83.0246 34.056 82.3106 32.18C81.5966 30.29 81.2396 28.218 81.2396 25.964C81.2396 23.71 81.5966 21.645 82.3106 19.769C83.0246 17.879 84.0326 16.255 85.3346 14.897C86.6366 13.525 88.1976 12.461 90.0176 11.705C91.8376 10.949 93.8536 10.571 96.0656 10.571C98.2776 10.571 100.294 10.949 102.114 11.705C103.948 12.461 105.516 13.525 106.818 14.897C108.12 16.255 109.128 17.879 109.842 19.769C110.556 21.645 110.913 23.71 110.913 25.964ZM106.734 25.964C106.734 24.116 106.482 22.457 105.978 20.987C105.474 19.517 104.76 18.278 103.836 17.27C102.912 16.248 101.792 15.464 100.476 14.918C99.1596 14.372 97.6896 14.099 96.0656 14.099C94.4556 14.099 92.9926 14.372 91.6766 14.918C90.3606 15.464 89.2336 16.248 88.2956 17.27C87.3716 18.278 86.6576 19.517 86.1536 20.987C85.6496 22.457 85.3976 24.116 85.3976 25.964C85.3976 27.812 85.6496 29.471 86.1536 30.941C86.6576 32.397 87.3716 33.636 88.2956 34.658C89.2336 35.666 90.3606 36.443 91.6766 36.989C92.9926 37.521 94.4556 37.787 96.0656 37.787C97.6896 37.787 99.1596 37.521 100.476 36.989C101.792 36.443 102.912 35.666 103.836 34.658C104.76 33.636 105.474 32.397 105.978 30.941C106.482 29.471 106.734 27.812 106.734 25.964ZM125.078 25.481C126.254 25.481 127.29 25.341 128.186 25.061C129.096 24.767 129.852 24.361 130.454 23.843C131.07 23.311 131.532 22.681 131.84 21.953C132.148 21.225 132.302 20.42 132.302 19.538C132.302 17.746 131.714 16.395 130.538 15.485C129.362 14.575 127.598 14.12 125.246 14.12H120.794V25.481H125.078ZM138.98 41H135.368C134.626 41 134.08 40.713 133.73 40.139L125.918 29.387C125.68 29.051 125.421 28.813 125.141 28.673C124.875 28.519 124.455 28.442 123.881 28.442H120.794V41H116.741V10.907H125.246C127.15 10.907 128.795 11.103 130.181 11.495C131.567 11.873 132.708 12.426 133.604 13.154C134.514 13.882 135.186 14.764 135.62 15.8C136.054 16.822 136.271 17.97 136.271 19.244C136.271 20.308 136.103 21.302 135.767 22.226C135.431 23.15 134.941 23.983 134.297 24.725C133.667 25.453 132.89 26.076 131.966 26.594C131.056 27.112 130.02 27.504 128.858 27.77C129.376 28.064 129.824 28.491 130.202 29.051L138.98 41ZM161.637 37.682L161.616 41H143.073V10.907H161.616V14.225H147.147V24.221H158.865V27.413H147.147V37.682H161.637Z" fill="white"/>
			<rect y="11" width="32" height="30" fill="url(#pattern0)"/>
			<path opacity="0.7" d="M191.816 14.897C191.69 15.135 191.508 15.254 191.27 15.254C191.088 15.254 190.85 15.128 190.556 14.876C190.276 14.61 189.891 14.323 189.401 14.015C188.911 13.693 188.295 13.399 187.553 13.133C186.825 12.867 185.922 12.734 184.844 12.734C183.766 12.734 182.814 12.888 181.988 13.196C181.176 13.504 180.49 13.924 179.93 14.456C179.384 14.988 178.964 15.604 178.67 16.304C178.39 17.004 178.25 17.739 178.25 18.509C178.25 19.517 178.46 20.35 178.88 21.008C179.314 21.666 179.881 22.226 180.581 22.688C181.281 23.15 182.072 23.542 182.954 23.864C183.85 24.172 184.767 24.48 185.705 24.788C186.643 25.096 187.553 25.439 188.435 25.817C189.331 26.181 190.129 26.643 190.829 27.203C191.529 27.763 192.089 28.456 192.509 29.282C192.943 30.094 193.16 31.109 193.16 32.327C193.16 33.573 192.943 34.749 192.509 35.855C192.089 36.947 191.473 37.899 190.661 38.711C189.849 39.523 188.855 40.167 187.679 40.643C186.503 41.105 185.159 41.336 183.647 41.336C181.687 41.336 180 40.993 178.586 40.307C177.172 39.607 175.933 38.655 174.869 37.451L175.457 36.527C175.625 36.317 175.821 36.212 176.045 36.212C176.171 36.212 176.332 36.296 176.528 36.464C176.724 36.632 176.962 36.842 177.242 37.094C177.522 37.332 177.858 37.598 178.25 37.892C178.642 38.172 179.097 38.438 179.615 38.69C180.133 38.928 180.728 39.131 181.4 39.299C182.072 39.467 182.835 39.551 183.689 39.551C184.865 39.551 185.915 39.376 186.839 39.026C187.763 38.662 188.54 38.172 189.17 37.556C189.814 36.94 190.304 36.212 190.64 35.372C190.976 34.518 191.144 33.608 191.144 32.642C191.144 31.592 190.927 30.731 190.493 30.059C190.073 29.373 189.513 28.806 188.813 28.358C188.113 27.896 187.315 27.511 186.419 27.203C185.537 26.895 184.627 26.594 183.689 26.3C182.751 26.006 181.834 25.677 180.938 25.313C180.056 24.949 179.265 24.487 178.565 23.927C177.865 23.353 177.298 22.646 176.864 21.806C176.444 20.952 176.234 19.888 176.234 18.614C176.234 17.62 176.423 16.661 176.801 15.737C177.179 14.813 177.732 14.001 178.46 13.301C179.188 12.587 180.084 12.02 181.148 11.6C182.226 11.166 183.451 10.949 184.823 10.949C186.363 10.949 187.742 11.194 188.96 11.684C190.192 12.174 191.312 12.923 192.32 13.931L191.816 14.897ZM219.186 13.112H208.749V41H206.586V13.112L196.086 13.112V11.285L219.186 11.285V13.112ZM235.066 39.467C236.494 39.467 237.768 39.222 238.888 38.732C240.022 38.228 240.981 37.535 241.765 36.653C242.549 35.771 243.144 34.735 243.55 33.545C243.97 32.341 244.18 31.046 244.18 29.66V11.285H246.322V29.66C246.322 31.298 246.063 32.831 245.545 34.259C245.027 35.673 244.278 36.912 243.298 37.976C242.332 39.026 241.149 39.852 239.749 40.454C238.363 41.056 236.802 41.357 235.066 41.357C233.33 41.357 231.762 41.056 230.362 40.454C228.976 39.852 227.793 39.026 226.813 37.976C225.847 36.912 225.105 35.673 224.587 34.259C224.069 32.831 223.81 31.298 223.81 29.66V11.285H225.973V29.639C225.973 31.025 226.176 32.32 226.582 33.524C227.002 34.714 227.597 35.75 228.367 36.632C229.151 37.514 230.103 38.207 231.223 38.711C232.357 39.215 233.638 39.467 235.066 39.467ZM279.735 26.132C279.735 28.428 279.392 30.493 278.706 32.327C278.02 34.161 277.054 35.722 275.808 37.01C274.562 38.298 273.064 39.285 271.314 39.971C269.578 40.657 267.66 41 265.56 41H254.703V11.285H265.56C267.66 11.285 269.578 11.628 271.314 12.314C273.064 13 274.562 13.987 275.808 15.275C277.054 16.563 278.02 18.124 278.706 19.958C279.392 21.792 279.735 23.85 279.735 26.132ZM277.509 26.132C277.509 24.06 277.222 22.212 276.648 20.588C276.074 18.964 275.262 17.592 274.212 16.472C273.162 15.352 271.902 14.498 270.432 13.91C268.962 13.322 267.338 13.028 265.56 13.028H256.866V39.257H265.56C267.338 39.257 268.962 38.963 270.432 38.375C271.902 37.787 273.162 36.933 274.212 35.813C275.262 34.693 276.074 33.321 276.648 31.697C277.222 30.073 277.509 28.218 277.509 26.132ZM288.777 41H286.614V11.285H288.777V41ZM323.962 26.132C323.962 28.428 323.619 30.514 322.933 32.39C322.247 34.252 321.281 35.848 320.035 37.178C318.789 38.494 317.291 39.516 315.541 40.244C313.805 40.958 311.887 41.315 309.787 41.315C307.687 41.315 305.769 40.958 304.033 40.244C302.297 39.516 300.806 38.494 299.56 37.178C298.314 35.848 297.348 34.252 296.662 32.39C295.976 30.514 295.633 28.428 295.633 26.132C295.633 23.85 295.976 21.778 296.662 19.916C297.348 18.04 298.314 16.444 299.56 15.128C300.806 13.798 302.297 12.769 304.033 12.041C305.769 11.313 307.687 10.949 309.787 10.949C311.887 10.949 313.805 11.313 315.541 12.041C317.291 12.755 318.789 13.777 320.035 15.107C321.281 16.437 322.247 18.04 322.933 19.916C323.619 21.778 323.962 23.85 323.962 26.132ZM321.736 26.132C321.736 24.06 321.449 22.198 320.875 20.546C320.301 18.894 319.489 17.494 318.439 16.346C317.389 15.198 316.129 14.323 314.659 13.721C313.189 13.105 311.565 12.797 309.787 12.797C308.023 12.797 306.406 13.105 304.936 13.721C303.466 14.323 302.199 15.198 301.135 16.346C300.085 17.494 299.266 18.894 298.678 20.546C298.104 22.198 297.817 24.06 297.817 26.132C297.817 28.218 298.104 30.087 298.678 31.739C299.266 33.377 300.085 34.77 301.135 35.918C302.199 37.066 303.466 37.941 304.936 38.543C306.406 39.145 308.023 39.446 309.787 39.446C311.565 39.446 313.189 39.145 314.659 38.543C316.129 37.941 317.389 37.066 318.439 35.918C319.489 34.77 320.301 33.377 320.875 31.739C321.449 30.087 321.736 28.218 321.736 26.132Z" fill="white"/>
			<defs>
			<pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
			<use xlink:href="#image0" transform="translate(0 -0.000512821) scale(0.00769231 0.00820513)"/>
			</pattern>
			<image id="image0" width="130" height="122" xlink:href="data:image/png;base64,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"/>
			</defs>
		</svg>
    </span>
</script>



<script type="text/template" id="tmpl-et-studio-menu">
    <ul>
        <li><a href="<?php echo wp_customize_url(); ?>"><?php echo esc_html__('Theme options', 'xstore-core'); ?></a></li>
        <li><a href="<?php etheme_documentation_url(); ?>" target="_blank"><?php echo esc_html__('Documentation', 'xstore-core' ); ?></a></li>
        <li><a href="https://www.8theme.com/forums/xstore-wordpress-support-forum/" target="_blank"><?php echo esc_html__('Support', 'xstore-core' ); ?></a></li>
    </ul>
</script>


<script type="text/html" id="tmpl-et-studio-actions">
    <div id="et-studio-sync" class="elementor-templates-modal__header__item">
        <i class="eicon-sync" aria-hidden="true" title="<?php esc_attr_e( 'Sync Library', 'xstore-core' ); ?>" et-title="<?php esc_attr_e( 'Refresh', 'xstore-core' ); ?>"></i>
    </div>
    <div class="et-studio-filters">
        <ul>
            <li><span><svg version="1.1" width="1em" height="1em" class="et-icon" fill="currentColor" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">
                        <path d="M94.8,0H5.6C4,0,2.6,0.9,1.9,2.3C1.1,3.7,1.3,5.4,2.2,6.7l32.7,46c0,0,0,0,0,0c1.2,1.6,1.8,3.5,1.8,5.5v37.5c0,1.1,0.4,2.2,1.2,3c0.8,0.8,1.8,1.2,3,1.2c0.6,0,1.1-0.1,1.6-0.3l18.4-7c1.6-0.5,2.7-2.1,2.7-3.9V58.3c0-2,0.6-3.9,1.8-5.5c0,0,0,0,0,0l32.7-46c0.9-1.3,1.1-3,0.3-4.4C97.8,0.9,96.3,0,94.8,0z M61.4,49.7c-1.8,2.5-2.8,5.5-2.8,8.5v29.8l-16.8,6.4V58.3c0-3.1-1-6.1-2.8-8.5L7.3,5.1h85.8L61.4,49.7z"></path>
                            </svg><span>Filter</span></span>
                <ul>
                    <# _.each(et_studio.library.et_filters, function(e, t) { #>
                        <li <# if (t == 'all') { #>class="et_studio-filter active"<# } else { #>class="et_studio-filter"<# } #> data-filter="{{{t}}}"><span>{{{e.title}}}</span><span class="count">{{{e.count}}}</span></li>
                    <# }); #>
                </ul>
            </li>
        </ul>
    </div>

    <div class="et-studio-search">
        <input type="text" placeholder="<?php echo esc_attr('Type searching...', 'xstore-core' ); ?>">
        <i>
            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" fill="currentColor" width="1em" height="1em" viewBox="0 0 24 24">
                <path d="M23.784 22.8l-6.168-6.144c1.584-1.848 2.448-4.176 2.448-6.576 0-5.52-4.488-10.032-10.032-10.032-5.52 0-10.008 4.488-10.008 10.008s4.488 10.032 10.032 10.032c2.424 0 4.728-0.864 6.576-2.472l6.168 6.144c0.144 0.144 0.312 0.216 0.48 0.216s0.336-0.072 0.456-0.192c0.144-0.12 0.216-0.288 0.24-0.48 0-0.192-0.072-0.384-0.192-0.504zM18.696 10.080c0 4.752-3.888 8.64-8.664 8.64-4.752 0-8.64-3.888-8.64-8.664 0-4.752 3.888-8.64 8.664-8.64s8.64 3.888 8.64 8.664z"></path>
            </svg>
        </i>
        <span class="spinner">
            <div class="et-loader ">
                <svg class="loader-circular" viewBox="25 25 50 50">
                    <circle class="loader-path" cx="50" cy="50" r="12" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
                </svg>
            </div>
        </span>
    </div>

</script>



<script type="text/template" id="tmpl-et-studio-back">
    <i class="eicon-" aria-hidden="true"></i>
    <span><?php esc_html_e( 'Back to Library', 'xstore-core' ); ?></span>
</script>

<script type="text/template" id="tmpl-et-studio-menu-responsive">
    <ul>
        <li>
            <a href="#" data-device="desktop" class="active">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2.5em" viewBox="0 0 24 24" width="2.5em"><path d="M0 0h24v24H0z" fill="none"/><path d="M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7l-2 3v1h8v-1l-2-3h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 12H3V4h18v10z"/></svg>
            </a>
        </li>
        <li>
            <a href="#" data-device="laptop">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2.5em" viewBox="0 0 24 24" width="2.5em"><path d="M0 0h24v24H0z" fill="none"/><path d="M20 18c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2H0c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2h-4zM4 5h16v11H4V5zm8 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/></svg>
            </a>
        </li>
        <li>
            <a href="#" data-device="mobile">
                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" height="2.5em" viewBox="0 0 24 24" width="2.5em"><path d="M0 0h24v24H0z" fill="none"/><path d="M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z"/></svg>
            </a>
        </li>
    </ul>
</script>



<script type="text/template" id="tmpl-et-studio-preview">
    <iframe></iframe>
</script>

<script type="text/template" id="tmpl-et-studio-header-insert">
    <div id="elementor-template-library-header-preview-insert-wrapper" class="elementor-templates-modal__header__item">
        {{{ et_studio.library.getModal().getTemplateActionButton( obj ) }}}
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-insert-button">
    <a class="elementor-template-library-template-action elementor-button et-studio-insert-button">
        <i class="eicon-file-download" aria-hidden="true"></i>
        <span class="elementor-button-title"><?php esc_html_e( 'Insert', 'xstore-core' ); ?></span>
    </a>
</script>

<script type="text/template" id="tmpl-et-studio-loading">
    <div class="elementor-loader-wrapper">
        <div class="elementor-loader">
            <div class="elementor-loader-boxes">
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
                <div class="elementor-loader-box"></div>
            </div>
        </div>
        <div class="elementor-loading-title"><?php esc_html_e( 'Loading', 'xstore-core' ); ?></div>
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-templates">
    <div class="et-studio-templates-window">
        <div class="et-studio-loader">
            <span class="et-studio-loaded-images" data-size="0">0</span>
        </div>
        <div class="et-studio-empty-search hidden">
            <img src="<?php echo ET_CORE_URL . 'app/models/studio/img/empty-search.png'; ?>" alt="empty-search">
            <h2>Whoops...</h2>
            <p>We couldn't find "<strong class="et-studio-empty-search-request">your word</strong>" shop you were looking for.</p>
        </div>
        <div id="et-studio-templates-list"></div>
    </div>
</script>

<script type="text/template"  id="tmpl-et-studio-template">
    <div class="et-studio-template-body elementor-template-library-template-body" data-tags="{{{tags}}}" data-cats="{{{cats}}}" id="et-template-{{ template_id }}">
        <img src="{{{thumbnail}}}" alt="{{{template_id}}}">
        <div class=" et-template-preview elementor-template-library-template-preview">
            <i class="eicon-zoom-in-bold" aria-hidden="true"></i>
        </div>
    </div>
    <div class="et-studio-template-footer elementor-template-library-template-footer">
        <a href="#" class="elementor-button et-template-preview-button">
            <i class="eicon-device-desktop" aria-hidden="true"></i>
            <?php esc_html_e( 'Preview', 'xstore-core' ); ?>
        </a>
        {{{ et_studio.library.getModal().getTemplateActionButton( obj ) }}}
    </div>
</script>

<script type="text/template" id="tmpl-et-studio-empty">
    <div class="elementor-template-library-blank-icon">
        <img src="<?php echo ELEMENTOR_ASSETS_URL . 'images/no-search-results.svg'; ?>" class="elementor-template-library-no-results" />
    </div>
    <div class="elementor-template-library-blank-title"></div>
    <div class="elementor-template-library-blank-message"></div>
    <div class="elementor-template-library-blank-footer">
    </div>
</script>