@extends('layout.admin')
@section('content')

<div class="cms-container">

    <div class="row margin-tb">

        <div class="col-lg-12 margin-tb">

            <div class="pull-left">

                <h2>Meta data</h2>

            </div>

            <div class="pull-right">

                <a class="btn btn-success" href="{{ route('admin.metadata.create') }}"> Create New Metadata</a>

            </div>

        </div>

    </div>


    @if ($message = Session::get('success'))

        <div class="alert alert-success">

            <p>{{ $message }}</p>

        </div>

    @endif


    <table class="table table-bordered">

        <tr>

            <th>No</th>

            <th>Title</th>

            <th>Description</th>

            <th width="280px">Action</th>

        </tr>

    @foreach ($items as $key => $item)

    <tr>

        <td>{{ ++$i }}</td>

        <td>{{ $item->title }}</td>

        <td>{{ $item->description }}</td>

        <td>

            <a class="btn btn-info" href="{{ route('admin.metadata.show',$item->id) }}">Show</a>
			<a class="btn btn-primary" href="{{ route('admin.metadata.edit',$item->id) }}">Edit</a>

            {!! Form::open(['method' => 'DELETE','route' => ['admin.metadata.destroy', $item->id],'style'=>'display:inline']) !!}
			{!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
            {!! Form::close() !!}

        </td>

    </tr>

    @endforeach

    </table>


    {!! $items->render() !!}

</div>

@endsection
