<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Role extends Model {

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'roles';
    protected $primaryKey = 'id';
    protected $fillable = ['id','role_id', 'role_slug',];
    public $timestamps = false;


    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */
    public function users() {
        return $this->belongsToMany('App\User','role_user','role_id','user_id');
    }

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */
    public function permissions() {
        return $this->belongsToMany('App\Permission');
    }

}
