<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::group(['middleware' => ['web']], function () {
    
Route::get('/', function () {
    return view('welcome');
});

Route::get('/json-data/pub-report-total',  'JsonController@getTotalPubReport');
 
Route::get('/json-data/pub-report',  'JsonController@getPubReport');

Route::post('/creat-ad/edit-ad',  'CreatadController@editAdSubmit');

Route::get('/creat-ad/get-detail',  'JsonController@geAdDetail');

Route::get('/json-data/get-profile',  'JsonController@getProfileDetail');

Route::get('/edit-ad',  'CreatadController@editad');

Route::post('/creat-ad/make-active-ad','CreatadController@make_active_ad');

Route::get('/creat-ad/make-active-ad','CreatadController@make_active_ad');

Route::post('/creat-ad/make-pause-ad','CreatadController@make_pause_ad');

Route::get('/creat-ad/make-pause-ad','CreatadController@make_pause_ad');

Route::post('/creat-ad/change-cpc','CreatadController@change_cpc');
Route::get('/creat-ad/change-cpc','CreatadController@change_cpc');

Route::post('/creat-ad/change-budget','CreatadController@change_budget');
Route::get('/creat-ad/change-budget','CreatadController@change_budget');

Route::get('/creat-ad/copy-ad','CreatadController@createCopyAd');

Route::post('/creat-ad/delete-ad',  'CreatadController@destroy_ad');
Route::get('/creat-ad/delete-ad',  'CreatadController@destroy_ad');

Route::get('/createpub',  'LoginController@create_pub');

Route::get('/login',  'LoginController@index');

Route::get('/testmail',  'LoginController@t_mailst');

Route::get('/register/verify/',  'LoginController@confirm');

Route::get('/recover/verify/',  'LoginController@resetAcc');

Route::post('/forgot',  'LoginController@forgotPassSubmit');

Route::post('/resetaccount',  'LoginController@resetAccSubmit');

Route::get('/myprofile', 'LoginController@user_profile');

Route::post('/login/updateProfile','CreatadController@editProfileDetail');

Route::post('/login',  'LoginController@create_user');

Route::post('/dologin',  'LoginController@validateUser');

Route::post('/index',  'LoginController@validateUser');

Route::get('/creat-ad',  'CreatadController@index');

Route::post('/create-ad',  'CreatadController@create_ad');

Route::get('/create-ad1',  'CreatadController@create_ad');

Route::post('/creat-ad/jsonaccept_post',  'CreatadController@create_ad');

Route::get('/creat-ad/create_ad_pages',  'CreatadController@create_ad_pages');

Route::get('/advertise_list',  'AdvertiseListController@index');

Route::get('/logout', 'LoginController@doLogout');
Route::get('/myaccount/logout', 'LoginController@doLogout');

Route::get('/myaccount', 'LoginController@user_accounts');

Route::get('/myaccount/reports', 'CreatadController@getReport');

Route::get('/myaccount/archive', 'CreatadController@archive');

Route::get('/myaccount/payments', 'PaymentsManagerController@getReport');

Route::get('/myaccount/addfunds', 'PaymentController@addfunds');

Route::post('/myaccount/addfunds', 'PaymentController@addfunds');

Route::post('/myaccount/paymentrequest', 'PaymentController@paymentRequest');
Route::post('/myaccount/paymentrequest2', 'PaymentController@paymentRequestHDFC');

Route::post('/myaccount/paymentresponse1', 'PaymentController@paymentResponsePayu');

Route::post('/myaccount/paymentresponse2', 'PaymentController@paymentResponseHDFC');

Route::post('/myaccount/paymentresponse3', 'PaymentController@paymentResponseFortumo');

Route::get('/myaccount/pubreports', 'CreatadController@getPubReport');

Route::get('/json-data/get-categories',  'JsonController@getCategories');

Route::get('/json-data/get-countries',  'JsonController@getCountries');

Route::get('/json-data/get-countries-fil',  'JsonController@getCountriesfil');

Route::get('/json-data/get-cities',  'JsonController@getAllCities');

Route::post('/creat-ad/create-ad-submit',  'CreatadController@createAdSubmit');

Route::get('/json-data/get-adinfo',  'JsonController@getAdInfoAdvertiser');

Route::get('/json-data/ad-report-total',  'JsonController@getTotalAdReportAdvertiser');

Route::get('/json-data/get-admin-adinfo',  'JsonController@getAdminAdInfo');

Route::get('/json-data/get-admin-pubinfo',  'JsonController@getAdminPubInfo');

Route::post('/json-data/get-report',  'JsonController@getReportInfoAdvertiser');
Route::get('/json-data/get-report',  'JsonController@getReportInfoAdvertiser');

Route::get('/json-data/get-devices',  'JsonController@getDevices');

Route::get('/json-data/get-os',  'JsonController@getOs');

Route::get('/json-data/get-osv',  'JsonController@getOsV');

Route::get('/json-data/get-browser',  'JsonController@getBrowser');

Route::get('/json-data/get-operator',  'JsonController@getOperator');

Route::get('/json-data/get-countries-name',  'JsonController@getCountriesName');

Route::post('/json-data/del-creative-items',  'JsonController@delCreativeGroupItems');

Route::post('/json-data/cpm-ad-admin',  'JsonController@adCpmCampaign');
Route::post('/json-data/cpaid-ad-admin',  'JsonController@adCpaIdCampaign');
Route::post('/json-data/adomain-ad-admin',  'JsonController@adAdomianCampaign');

Route::post('/json-data/cpaid-ad-admin',  'JsonController@adCpaIdCampaign');

Route::get('/payment/request',  'PaymentController@paymentRequest');

Route::get('/payment/hdfc',  'PaymentController@hdfcPayment');

Route::get('/payment/response',  'PaymentController@paymentResponse');

Route::get('auth/facebook', 'Auth\AuthController@redirectToProvider');
Route::get('auth/facebook/callback', 'LoginController@handleProviderFbCallback');

Route::get('auth/google', 'Auth\AuthController@redirectToGoogleProvider');
Route::get('auth/google/callback', 'LoginController@handleProviderGoogleCallback');

/* 31.03.2016 start code Yogendra */

Route::get('/myaccount/paymenthistory', 'PaymentsManagerController@paymentHistory');
Route::post('/requestrefund', 'PaymentsManagerController@requestrefund');

Route::get('/invoicedetailspdf', 'InvoiceController@invoicedetailspdf');
Route::get('/invoicedetailspdfdwn', 'InvoiceController@invoicedetailspdfdwn');
Route::get('/json-data/get-timezone',  'JsonController@getTimezoneData');
Route::get('/json-data/get-browser-ver',  'JsonController@getBrowserV');
Route::get('/json-data/get-os-ver',  'JsonController@getOsV');
Route::post('/creat-ad/checkbalance_left_dollar',  'JsonController@editcheck_balance_left_dollar');
Route::post('/json-data/editcheckbalance_left_dollar',  'CreatadController@check_balance_left_dollar');

Route::get('/setcurrency', 'LoginController@user_currencyview');
Route::post('/setcurract', 'LoginController@setcurract');
Route::get('/banner-gallery','CreatadThemesController@banner_gallery');
Route::get('/banner-data/get-gallery',  'CreatadThemesController@getGallery');

Route::post('/creatad-crop/uploadcrop',  'CreatadThemesController@uploadcrop');
Route::post('/creatad-crop/uploadcropedit',  'CreatadThemesController@uploadcropedit');

Route::post('/creatad-crop/upload-banner-add',  'CreatadThemesController@uploadBannerAdd');
Route::post('/creatad-crop/upload-banner-edit',  'CreatadThemesController@uploadBannerEdit');

Route::get('/web-page-creation-edit','CreatadThemesController@CreateWebpageEdit');

Route::post('/web-page-creation/add-web-data-edit',  'CreatadThemesController@addWebDataEdit');

Route::get('/manage-webpages','CreatadThemesController@manage_webpages');

Route::get('/webpage-data/get-my-list',  'CreatadThemesController@getmywebpageList');

Route::get('/show-webpage','CreatadThemesController@show_webpage');

Route::post('save-webpage','CreatadThemesController@saveWebPage');

Route::post('cancel-webpage','CreatadThemesController@deleteWebPagePending');

Route::post('/faqsdata','menuController@faqsdata');

Route::get('/creat-ad/ad-detail',  'CreatadController@adDetail');

Route::get('/json-data/get-cities-data',  'JsonController@getSelectedCities');

/* 31.03.2016 start code end */


/*Add by Sonu Dated-2016-03-29 */
Route::get('/theme_creation',  'CreatadThemesController@themeCreation');

Route::get('/web-page-creation','CreatadThemesController@CreateWebpage');

Route::post('/web-page-creation/add-web-data',  'CreatadThemesController@addWebData');

Route::get('/web-page-preview','CreatadThemesController@previewWebData');

Route::get('/banner-page-creation','CreatadThemesController@bannerCreateData');

Route::get('/banner-page-creation-edit','CreatadThemesController@bannerCreateDataEdit');

Route::post('/banner-creation','CreatadThemesController@bannerGenrate');

Route::get('/crop_tool','CreatadThemesController@cropimage');

Route::get('/crop_tool_edit','CreatadThemesController@cropimageedit');

Route::post('/cropimage_post','CreatadThemesController@cropimage_post');

Route::get('/aboutus','menuController@aboutus');

Route::get('/technology','menuController@technology');

Route::get('/terms-and-conditions','menuController@termsandconditions');

Route::get('/partner-certification','menuController@partnercertification');

Route::get('/contactus','menuController@contactus');

Route::post('/contactusdata','menuController@contactusdata');

Route::get('/faq','menuController@faqs');

Route::post('/redeem-coupon','CouponsController@redeemCoupons');

/*End here Added by Sonu */

Event::listen('illuminate.query',function($query){  
    var_dump($query);
});

});
Route::get('500', function()
{
    abort(500);
});
Route::controllers([
    'auth' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);
