<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD

class PaymentsManagerController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function paymentHistory(Request $request) {
        $this->session = SESSION::All();
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        }

        $start = ( $request->start ) ? $request->start . '000000' : date("Ymd") . '000000';
        $end = ( $request->end ) ? $request->end . '235959' : date("Ymd") . '235959';

        
        if (Auth::check() && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $statModel = new \App\AccountFunds();
            $statData = $statModel::where(array('account_id' => $this->session['sessiondata']['accounts'][0]['account_id'], 'debit_credit' => 'CREDIT'))
                    ->whereBetween(DB::raw(" date(insert_datetime) "), array($start, $end))
                    ->selectRaw("transaction_id,account_id,user_id,amount,currency,payment_status,debit_credit,commments,insert_datetime")
                    ->orderBy('insert_datetime', 'desc')
                    ->get();
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            return view('mypayments', ['dataFund' => $statData,'dateTimeObj'=>$dateTimeObj,'currency'=>$this->session['sessiondata']['accounts'][0]['adv_currency']]);
        }
    }

    public function addfunds() {
        return view('addfunds');
    }

    public function submitaddfundsstep1() {

        $return = PaymentController::paymentRequest();
        print_r($return);
        exit;
    }

    public function requestrefund(Request $request) {
        $useremail = 'yogendra.d@collectcent.com';
        $umessage = $request->umessage;
        $usubject = $request->usubject;
        $email = 'care@audiencenest.com';
        $replymsg = 'Thanks for the submitting request, our customer account team will contact you shrotly.';
        Mail::send('email_refund_admin', ['UserEmailID' => $useremail, 'UserMessage' => $umessage, 'UserSubject' => $usubject], function($message) use ($email) {
            //$message->to($email)
            $message->from('no-reply@audiencenest.com', 'Request Refund')
                    ->to($email, 'Admin')
                    ->subject('Request Refund');
        });

        Mail::send('email_refund', ['UserEmailID' => $useremail, 'replymsg' => $replymsg, 'subj' => 'Request Refund Acknowledgement'], function($message) use ($useremail) {
            //$message->to($email)
            $message->from('no-reply@audiencenest.com', 'Request Refund ACK')
                    ->to($useremail, 'Advertiser')
                    ->subject('Request Refund Acknowledgement');
        });

        $statusArr = array('status' => 'ok');
        return json_encode($statusArr);
    }

}
