<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Validator;
use DB;
use Auth;
use Hash;
use App\User;
use Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class LoginController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        
        $ipAddress = ip2long ( $_SERVER['REMOTE_ADDR'] );
        if ( array_key_exists('HTTP_X_FORWARDED_FOR', $_SERVER) ) {
            $ipAddress = ip2long ( array_pop(explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])));
        }
        
        $countryId  =   "226";
        $ipAddress = ip2long ( "204.147.128.0" );
        $ispModel   = new \App\MaxmindData();
        $ispData    =   $ispModel::join('country', function( $join ) {
                        $join->on('maxmind_ip_pool.iso_country_code', '=', 'country.iso');
                        })
                        ->selectRaw("country.id")
                        ->where("maxmind_ip_pool.long_higher_ip",">=", $ipAddress )
                        ->where("maxmind_ip_pool.long_lower_ip","<=", $ipAddress )
                        ->get();
        
        if( isset( $ispData[0]->id ) ){
            $countryId  =   $ispData[0]->id;
        }
        
        //echo "<pre>";print_r( $ispData );die;
        return View('/login')->with('country_id', $countryId );
        
    }

    /**
     * Show the form for login validated the users.
     * This function is use for validated the a user in login process
     * @return \Illuminate\Http\Response
     */
    public function validateUser(Request $request) {

        if (Auth::attempt(['email_address' => $request->Email, 'password' => $request->Password])) {

            $user = Auth::user();
            if ($user) {
                Session::put('UserID', $user->user_id);
                return redirect()->intended('/');
            }
      else {
         return redirect('/login')->with('error_login', 'Please provide valid email and password');
        }
            
        } else {
            return redirect('/login')->with('error_login', 'Please provide valid email and password');
        }
    }

    /**
     * redirect to myaccount.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function user_accounts() {

        return View("/myaccount");
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store() {
        // 
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_user(Request $request) {
    //
      
        $email = $request->email;
        $password = $request->password;
        $phone = $request->phone;
        $captcha=$request->captcha;
        $validator = Validator::make(
                        array(
                    'email' => $request->email,
                    'password' => $password = Hash::make($request->password),
                    'phone_number' => $request->phone,
                    'captcha'=>$request->captcha,        
                        ), array(
                    'email' => 'required | email',
                    'password' => 'required ',
                    'phone_number' => 'required',
                     'captcha' =>  'required',
                        )
        );

        if ($validator->fails()) {
            return redirect('/login')->withErrors($validator)->withInput();
        } else {
            $data = array(
                "email_address" => $email,
                "password" => $password,
            );
          
            if (DB::table('cf_users')->insert($data)) {
                return redirect('/login')->with("success_singup", "Success Full Sing UP");
            } else {
                return redirect('/login')->with("error", "Not Insert");
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    /**
     * Logout the specified resource user.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function doLogout() {
        Auth::logout();
        Session::flush();
        return redirect('/');
    }

}

