<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Webpage extends Model {

    protected $table = 'advertiser_webpage';
    protected $primaryKey = 'page_id';
    protected $fillable = ["page_id", "webpage_name", "advertiser_id", "body_bg_color", "heading_bg_color", "heading_txt_color",
        "heading_text", "mid_bg_color", "mid_txt_color", "mid_text", "mid_image_isflg", "mid_imagename", "mid_youtube_url", "footer_bg_color",
        "footer_txt_color", "footer_address", "footer_phone", "footer_email", "added_date", "modified_date", "url",];
    public $timestamps = false;
    public function advertiser() {
        return $this->belongsTo('\App\Advertiser', 'advertiser_id');
    }

}
