<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PaymentTransaction extends Model {

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'payment_transactions';
    protected $primaryKey = 'id';
    protected $fillable = ['transaction_id', 'parent_id','account_id','user_id','amount','currency','stage','payment_status',
        'status_reason','gateway_id','payment_mode','gateway_transaction_id','gateway_status_reason',
        ];
    public $timestamps = false;

    
    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */

     public function advertiser_details()
    {
        return $this->belongsTo('App\Advertiser','account_id');
    }

}
