<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use App\User;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD
use Detection\MobileDetect as MobileDetect;

class PaymentsManagerController extends Controller {

    public function __construct() {
        $this->middleware('auth');
        $this->sessionRefresh();
    }

    public function paymentHistory(Request $request) {
        $this->session = SESSION::All();


        $sessiondata = Session::get('sessiondata');
		$detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');

        if (!isset($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 00:00:00');
        } else {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $request->start . ' 00:00:00');
        }
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $sdt = $dateTimeObj->format('YmdHis');

        if (!isset($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', date("d-m-Y") . ' 23:59:59');
        } else {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y H:i:s', $request->end . ' 23:59:59');
        }
        $dateTimeObj->setTimezone(new \DateTimeZone('Asia/Kolkata'));
        $edt = $dateTimeObj->format('YmdHis');


        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        }


        if (Auth::check() && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $statModel = new \App\AccountFunds();


            $statData = $statModel::where(array('account_id' => $this->session['sessiondata']['accounts'][0]['account_id'], 'debit_credit' => 'CREDIT'))
                    ->where('insert_datetime', '>=', $sdt)
                    ->where('insert_datetime', '<=', $edt)
                    ->selectRaw("transaction_id,account_id,user_id,amount,currency,payment_status,debit_credit,commments,insert_datetime")
                    ->orderBy('insert_datetime', 'desc')
                    ->get();


            
            $spend_qr= $users = DB::table('motion_sitewise_report')
                    ->select(DB::raw('sum(spend) as spend'))
                    ->where('status', '=', '1')
//                    ->groupby("publisher")
                    ->get();
            
            $total_spend = 0;
            
            foreach ($spend_qr as $statRow) {
                 $total_spend += $statRow->spend;
            }
            
//            echo "TOTAL SPEND = ".$total_spend;
            
            $payment_data = array();
            $counter = 0;
            foreach ($statData as $statRow) {

                $dateTimeObj = \DateTime::createFromFormat('Y-m-d H:i:s' , $statRow['insert_datetime']);
                //change date time to user's timezone
                $dateTimeObj->setTimezone(new \DateTimeZone($this->session['sessiondata']['user_timezone']));
                $payment_data[$counter]['transaction_id'] = $statRow['transaction_id'];
                $payment_data[$counter]['amount'] = $statRow['amount'];
                $payment_data[$counter]['insert_datetime'] = $dateTimeObj->format('d-m-Y');
                $payment_data[$counter]['debit_credit'] = $statRow['debit_credit'];
                $payment_data[$counter]['comments'] = $statRow['comments'];
                $counter++;
            }

            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);

           


            $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                  
            $result = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiser_id)->get();


            $balance_left_curr = 0;
            if (!empty($result)) {

                $balance_left_curr = $result[0]->balance_left_currency - $total_spend;
//                $balance_left_curr = $total_spend;
            }

        return view('mypayments', ['dataFund' => $payment_data, 'dateTimeObj' => $dateTimeObj, 'currency' => $this->session['sessiondata']['accounts'][0]['adv_currency'], 'currentFund' => $balance_left_curr]);
		/*if ($deviceType == 'computer') {
            return view('mypayments', ['dataFund' => $payment_data, 'dateTimeObj' => $dateTimeObj, 'currency' => $this->session['sessiondata']['accounts'][0]['adv_currency'], 'currentFund' => $balance_left_curr]);
			}
		else{
			return view('mob-mypayments', ['dataFund' => $payment_data, 'dateTimeObj' => $dateTimeObj, 'currency' => $this->session['sessiondata']['accounts'][0]['adv_currency'], 'currentFund' => $balance_left_curr]);
			}*/
        }
    }

    public function addfunds() {
        return view('addfunds');
    }

    public function submitaddfundsstep1() {

        $return = PaymentController::paymentRequest();
        print_r($return);
        exit;
    }

    public function requestrefund(Request $request) {
	$sessiondata = Session::get('sessiondata');
        $advertiserId = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
	$resultk = DB::table('dl_advertisers')->select('contact_email')->where('advertiser_id', $advertiserId)->get();
	$useremail = $resultk[0]->contact_email;
        //$useremail = 'yogendra.d@collectcent.com';
        $umessage = $request->umessage;
        $usubject = $request->usubject;
        $email = 'ab@vola.ad';
        $replymsg = 'Thanks for the submitting request, our customer account team will contact you shortly.';
        Mail::send('email_refund_admin', ['UserEmailID' => $useremail, 'UserMessage' => $umessage, 'UserSubject' => $usubject], function($message) use ($email) {
            //$message->to($email)
            $message->from('no-reply@vola.ad', 'Request Refund')
                    ->to($email, 'Admin')
                    ->subject('Request Refund');
        });

        Mail::send('email_refund', ['UserEmailID' => $useremail, 'replymsg' => $replymsg, 'subj' => 'Request Refund Acknowledgement'], function($message) use ($useremail) {
            //$message->to($email)
            $message->from('no-reply@vola.ad', 'Request Refund ACK')
                    ->to($useremail, 'Advertiser')
                    ->subject('Request Refund Acknowledgement');
        });

        $statusArr = array('status' => 'ok');
        return json_encode($statusArr);
    }

    public function getAdvId($userId) {

        if ($userId) {

            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
           
            if ($publisher->advertiser_id > 0) {

                return $publisher->advertiser_id;
            }
        }

        return null;
    }

}
