<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests\MetaRequest;
use App\Http\Controllers\Controller;
use App\Metadata;

class MetadataController extends Controller
{
        /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */
     public function __construct() {
		$this->middleware('auth');
		/* if (!Auth::check()) {
            return false;
        }*/
     }

    public function index(Request $request){
	   $items = Metadata::orderBy('id','DESC')->paginate(5);
       return view('metadata.index',compact('items'))->with('i', ($request->input('page', 1) - 1) * 5);

    }


    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create(){
		return view('metadata.create');
	}


    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(MetaRequest $request)

    {

        /* $this->validate($request, [

            'title' => 'required',
            'slug' => 'required',
            'keyword' => 'required',
            'description' => 'required',

        ]);
        */

        Metadata::create($request->all());

        return redirect()->route('admin.metadata.index')->with('success','Item created successfully');

    }


    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        $item = Metadata::find($id);

        return view('metadata.show',compact('item'));

    }


    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id)

    {
        
        $item = Metadata::find($id);
        
        return view('metadata.edit',compact('item'));

    }


    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(MetaRequest $request, $id)

    {

       /* $this->validate($request, [
			'title' => 'required',
            'slug' => 'required',
            'keyword' => 'required',
            'description' => 'required',

        ]); */


        Metadata::find($id)->update($request->all());

        return redirect()->route('admin.metadata.index')->with('success','Item updated successfully');

    }


    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)
    {

        Metadata::find($id)->delete();
        return redirect()->route('admin.metadata.index')->with('success','Item deleted successfully');

    }
}
