<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Validator;
use Socialite;
use DB;
use Auth;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD
use Hash;
use App\User;
use App\Advertiser;
use Detection\MobileDetect as MobileDetect;
use Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Mobile_Detect;
class LoginController extends Controller {
    /*     * find
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index() {
        if (Auth::check()) {
            return redirect("/");
            // The user is logged in...
        }
        if (isset($_COOKIE['au_email_address']) && isset($_COOKIE['au_token'])) {
            $au_email_address = base64_decode(trim($_COOKIE['au_email_address']));
            $au_token = base64_decode(trim($_COOKIE['au_token']));
            $authkey = 'email_address';
            if (Auth::attempt([$authkey => $au_email_address, 'password' => $au_token, 'is_active' => 1])) {
              $this->sessionRefresh();
                return redirect('/myaccount');
            } else {
                $json_url = url("json-data/get-countries");
                $json = file_get_contents($json_url);
                $data = json_decode($json, true);

                $countryId = $this->getCountryId();
                return View('/login', ['countries' => $data])->with('country_id', $countryId);
            }
        } else {

            $json_url = url("json-data/get-countries");
            $json = file_get_contents($json_url);
            $data = json_decode($json, true);

            $countryId = $this->getCountryId();
            return View('/login', ['countries' => $data])->with('country_id', $countryId);
        }
    }

    public function pubindex(Request $request) {

        if (Auth::check()) {
            return redirect("/myaccount");
            // The user is logged in...
        }
        return View('/publogin');
    }

    /**
     * Show the form for login validated the users.
     * This function is use for validated the a user in login process
     * @return \Illuminate\Http\Response
     */
    public function validateUser(Request $request) {
		$name = $request->input('email_address');
		if ($request->email_address) {
            $validator = Validator::make(
                            array(
                        'email_address' => $request->email_address,
                            ), array(
                        'email_address' => 'required|email',
                            )
            );
            if ($validator->fails()) {
                $authkey = 'phone_number';
            } else {
                $authkey = 'email_address';
            }
        }
        if (Auth::attempt(['email_address' => $request->email_address, 'password' => $request->password, 'is_active' => 1])) {
            $user = Auth::User();
		
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;
				if (!empty($user->country_id)) {
						$sessdata['country_id'] = $user->country_id;
					} else {
						$sessdata['country_id'] = $this->getCountryId();
					}
					if (empty($user->user_timezone)) {
						$tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
								->get()
								->first();
						$sessdata['user_timezone'] = trim($tz_data->zone_name);
					} else {
						$sessdata['user_timezone'] = trim($user->user_timezone);
					}
                switch ($sessdata['roles'][0]['role_id']) {

                    case 1:
                        break;
                    case 2:
                    $parse = parse_url($request->getHttpHost());
                  	 $url = preg_replace('#^www\.(.+\.)#i', '$1', $parse['path']);
                        if ($url !== config('app.apphost')) {
                            Auth::logout();
                            Session::flush();
                            return redirect('/login')->with('error_login', 'Please provide valid email and password');
                        }

                        $count = 0;
                        foreach ($user->accounts as $accounts) {

                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                            $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            $count++;
                        }
					break;
                    case 4:
                     $parse = parse_url($request->getHttpHost());
                    $url = preg_replace('#^www\.(.+\.)#i', '$1', $parse['path']);
                        // if ($request->getHttpHost() !== config('app.pubhost')) {
                        if ($url  !== config('app.pubhost')) {
                            Auth::logout();
                            Session::flush();
                            return redirect('/login')->with('error_login', 'Please provide valid email and password');
                        }
                        $count = 0;
                        foreach ($user->accounts as $accounts) {

                            $publisher = $accounts->publisher;
                            $publisher = $publisher->toArray();
                            $sessdata['accounts'][$count]['publisher_id'] = $publisher['publisher_id'];
                            $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                            $count++;
                        }
                        break;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
                if (isset($request->term) && trim($request->term == '1')) {
                    setcookie("au_email_address", base64_encode($request->email_address), time() + 7200);
                    setcookie("au_token", base64_encode($request->password), time() + 7200);
                }
            }

            if (trim($request->refs) != '') {
                $refsd = trim($request->refs);
                return redirect('/' . $refsd);
            } else {
                return redirect('/myaccount');
            }
        } else {

            return redirect('/login')->with(array('error_login' => 'Submitted email address / mobile number and password do not match. Please check and submit again. ', 'email_address' => $request->email_address))->withInput();
        }
    }

    /**
     * redirect to myaccount.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function user_accounts() {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $this->sessionRefresh();
        $session = Session::all();

        $detect = new MobileDetect();
        // get_class(MobileDetect());die;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        //$currency = $this->getCurrencyFromAccount($session['sessiondata']['accounts'][0]['account_id']);

        switch ($session['sessiondata']['roles'][0]['role_slug']) {
            case 'ADVERTISER':
                $tzObj = new \DateTimeZone(isset($session['sessiondata']['user_timezone'])?$session['sessiondata']['user_timezone']:'Asia/Kolkata');
                $dateTimeObj = new \DateTime('now', $tzObj);



                $accountid = $session['sessiondata']['accounts'][0]['account_id'];
                //$accountid=21;
                $userAdv = Advertiser::where('account_id', '=', $accountid)->get()->first();

                if (!empty($userAdv) && isset($userAdv['account_id'])) {
                    if (trim($userAdv['currency']) == '') {
                        return redirect("/setcurrency");
                    }
                }


                if ($deviceType == 'computer') {
                    return View("/myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'], 'account_bl_currency' => $userAdv['balance_left_currency']]); //advertiser account
                } else {
                    return View("/mob-myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'], 'account_bl_currency' => $userAdv['balance_left_currency']]); //advertiser account
                }

                // return View("/myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'],'account_bl_currency'=>$userAdv['balance_left_currency']]); //advertiser account
                break;
            case 'MANAGER':
                return View("/advaccounts"); // list of advertiser accounts
                break;
            case 'ADMIN':
                return redirect("/admin/home");
                 // list of advertiser accounts
                break;
            case 'PUBLISHER':
            case 'TRAFFICKER':
                $dateTimeObj = new \DateTime('now');
                return View("/pubaccount_date", ['dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]); // publisher account
                break;
        }
    }



	public function sitewise( ) {
	 if (!Auth::check()) {
            return redirect('/login');
        }
        $this->sessionRefresh();
        $session = Session::all();

        $detect = new MobileDetect();
        // get_class(MobileDetect());die;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        //$currency = $this->getCurrencyFromAccount($session['sessiondata']['accounts'][0]['account_id']);

        switch ($session['sessiondata']['roles'][0]['role_slug']) {
            case 'ADVERTISER':
                $tzObj = new \DateTimeZone(isset($session['sessiondata']['user_timezone'])?$session['sessiondata']['user_timezone']:'Asia/Kolkata');
                $dateTimeObj = new \DateTime('now', $tzObj);



                $accountid = $session['sessiondata']['accounts'][0]['account_id'];
                //$accountid=21;
                $userAdv = Advertiser::where('account_id', '=', $accountid)->get()->first();

                if (!empty($userAdv) && isset($userAdv['account_id'])) {
                    if (trim($userAdv['currency']) == '') {
                        return redirect("/setcurrency");
                    }
                }


                if ($deviceType == 'computer') {
                    return View("/myaccountsite", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'], 'account_bl_currency' => $userAdv['balance_left_currency']]); //advertiser account
                } else {  return View("/mob-myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'], 'account_bl_currency' => $userAdv['balance_left_currency']]); //advertiser account
                }

                // return View("/myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone'],'account_bl_currency'=>$userAdv['balance_left_currency']]); //advertiser account
                break;
            case 'MANAGER':
                return View("/advaccounts"); // list of advertiser accounts
                break;
            case 'ADMIN':
                return redirect("/admin/home");
                 // list of advertiser accounts
                break;
            case 'PUBLISHER':
            case 'TRAFFICKER':
                $dateTimeObj = new \DateTime('now');
                return View("/pubaccount_date", ['dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]); // publisher account
                break;
        }
                               
		

	

	}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store() {
        //
    }

    /*     * * Set user currency view
     *

     */

    public function user_currencyview() {


        $json_url = url("json-data/get-timezone");
        $json = file_get_contents($json_url);

        $data = json_decode($json, true);
        $countryId = $this->getCountryId();
        $tz_data = \App\TimezoneData::where('iso3_country_code', $countryId)
                ->get()
                ->first();
        $usertz = $tz_data->zone_name . "#" . $tz_data->utc_offset;

        return View("/setcurrency", ['tzdatas' => $data, 'countryCode' => $countryId, 'usertz' => $usertz]);
    }

    public function setcurract(Request $request) {
        $curncy = trim($request->currency);
        if ($curncy == '') {
            $curncy = 'INR';
        }
        $tmzone = trim($request->timezone);

        $session = Session::all();
        if ($curncy != '' && $tmzone != '') {
            $tmArr = explode("#", $tmzone);
            $utcoffset = $tmArr[1];
            $timezn = $tmArr[0];
            $userid = isset($session['UserID'])?$session['UserID']:'';
            $advertiser_id = isset($session['sessiondata']['accounts'][0]['advertiser_id'])?$session['sessiondata']['accounts'][0]['advertiser_id']:'';
            $account_id = isset($session['sessiondata']['accounts'][0]['account_id'])?$session['sessiondata']['accounts'][0]['account_id']:'';

            $user_model = \App\User::where('user_id', "=", $userid)
                    ->update(['utc_offset' => $utcoffset, 'user_timezone' => $timezn]);


            $adv_model = \App\Advertiser::where('account_id', "=", $account_id)
                    ->update(['currency' => $curncy, 'default_currency' => $curncy]);

            $sessdata = array();
            $sessdata['country_id'] = $session['sessiondata']['country_id'];

            $sessdata['roles'][0]['role_id'] = $session['sessiondata']['roles'][0]['role_id'];
            $sessdata['roles'][0]['role_slug'] = $session['sessiondata']['roles'][0]['role_slug'];

            $sessdata['accounts'][0]['account_id'] = $session['sessiondata']['accounts'][0]['account_id'];
            $sessdata['accounts'][0]['account_type'] = $session['sessiondata']['accounts'][0]['account_type'];

            $sessdata['accounts'][0]['advertiser_id'] = $session['sessiondata']['accounts'][0]['advertiser_id'];
            $sessdata['accounts'][0]['adv_currency'] = $curncy;
            $sessdata['flage_value']=1;
            $sessdata['user_timezone'] = $timezn;


            Session::put('sessiondata', $sessdata);
            return redirect("/advertise_list");
        }
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_user(Request $request) { // create advertiser
        $email = $request->email_address;
        $password = $request->password;
        $password = $request->password_confirmation;
        $phone = $request->phone_number;
        $captcha = $request->captcha;
        //$currency = $request->currency;
        $validator = Validator::make(
                        array(
                    'email_address' => $request->email_address,
                    'password' => $password = $request->password,
                    'password_confirmation' => $request->password_confirmation,
                        //'phone_number' => $request->phone_number,
                        //'phone_country_code' => $request->country_code,
                        //'captcha' => $request->captcha,
                        //'currency'=>$request->currency,
                        ), array(
                    'email_address' => 'required|email|unique:cf_users',
                    'password' => 'required|confirmed|min:6',
                        // 'phone_number' => 'required|unique:cf_users',
                        // 'phone_country_code' => 'required',
                        //'currency'=>'required',
                        // 'captcha' => 'required|captcha',
                        )
        );

        /* $validator->after(function($validator) {

          $validator->errors()->add('captcha', 'Your input captcha is worng!');
          });

         */

        if ($validator->fails()) {
            return redirect('/login?refer=advertise_list')->withErrors($validator)->with(array('email_address1' => $request->email_address, 'phone_number' => $request->phone_number))->withInput();
        } else {
            $data = array(
                "email_address" => $email,
                "password" => Hash::make($password),
                'phone_number' => '',
                    // 'phone_country_code' => $request->country_code,
            );

            $userw = User::where('email_address', '=', $email)->get()->first();
          
            //$user = User::whereConfirmationCode($confirmation_code)->first();

            if (!$userw) {
                /* create an account during sign up
                  insert order
                  1) cf_accounts
                  2) cf_users -- dependency: cf_accounts->account_id
                  3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

                 */
                $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
                if (!empty($this->account_id) && is_numeric($this->account_id)) {
                    $data['default_account_id'] = $this->account_id;
                    $confirmation_code = str_random(30);
                    $data['activation_code'] = $confirmation_code;
                    //$data['utc_offset'] = $this->getUtcOffset();
                    $data['country_id'] = $this->getCountryId();
                    $data['created_at'] = date('Y-m-d H:i:s');
                    //$data['default_language'] = $this->getDefaultLanguage();

                    $this->user_id = DB::table('cf_users')->insertGetId($data);
                    if ($this->user_id && is_numeric($this->user_id)) {
                        DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                            'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'], 'contact_mobile' => $data['phone_number'], 'contact_phone' => $data['phone_number'], 'status' => 1, 'create_date_time' => date('Y-m-d H:i:s')));
                        DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                        DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));
                        $name_Arr = explode("@", $email);
                        $shname = $name_Arr[0];
                        Mail::send('email_verify', ['confirmation_code' => $confirmation_code, 'name' => $shname, 'usemail' => $email], function($message) use ($email) {
                            //$message->to($email)
                            $message->from('no-reply@audiencenest.com', 'Vola.ad')
                                    ->to($email, 'Advertiser')
                                    ->subject('Complete your Sign Up process');
                        });

                        return redirect('/login')->with("success_singin", "Thanks. You have successfully signed-up. Please visit your mailbox and click on the link sent in account activation email to activate your account. ");
                    }
                }
                return redirect('/login')->with("error_signin", "Not Insert");
            } else {
                return redirect('/login')->with(array('error_signin' => 'An account already exists with the email address / mobile number. Please click on the log-in tab to access your account.', 'email_address1' => $request->email_address, 'phone_number' => $request->phone_number))->withInput();
            }
        }
    }

    public function create_pub(Request $request) { // create advertiser

        /* uncomment the code to make it live
         *
         *
          $email = $request->email_address;
          $password = $request->password;
          $password = $request->password_confirmation;
          $phone = $request->phone_number;
          $captcha = $request->captcha;
          $validator = Validator::make(
          array(
          'email_address' => $request->email_address,
          'password' => $password = $request->password,
          'password_confirmation' => $request->password_confirmation,
          'phone_number' => $request->phone_number,
          'captcha' => $request->captcha,
          'country_code' => $request->country_code,
          ), array(
          'email_address' => 'required|email|unique:cf_users',
          'password' => 'required|confirmed|min:6',
          'phone_number' => 'required|unique:cf_users',
          'country_code' => 'required',
          //'captcha'=>'required|captcha',
          )
          );


          if ($validator->fails()) {
          return redirect('/regpub')->withErrors($validator)->withInput();
          } else {
          $data = array(
          "email_address" => $email,
          "password" => Hash::make($password),
          'phone_number' => $request->phone_number,
          'phone_country_code' => $request->country_code,
          );


          /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        /* end comment */

        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'TRAFFICKER'));
        $data['email_address'] = 'newpub@gmail.com';

        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;
            $confirmation_code = str_random(30);
            $data['activation_code'] = $confirmation_code;

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('role_user')->insert(array('role_id' => 3, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));
                /*
                  Mail::send('email_verify', ['confirmation_code'=>$confirmation_code], function($message) use ($email) {
                  //$message->to(Input::get('email_address'), Input::get('username'))
                  $message->from('admin@audience.nest','hello');
                  $message->to($email, 'Advertiser')
                  ->subject('Verify your Email address');
                  }); */

                //Flash::message('Thanks for signing up! Please check your email.');
                DB::table('publishers')->insertGetId(array('publisher_key' => 'keypub34567', 'company' => 'pubcompany',
                    'contact_email' => $data['email_address'], 'account_id' => $this->account_id));
                exit;
                //return redirect('/login')->with("success_singup", "Sing Up Successfull. Please check your mail to verify Email.");
            }
        }
        return redirect('/login')->with("error_after_loging", "Not Insert");
    }

    public function confirm(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;


        if (!$confirmation_code) {
            throw new InvalidConfirmationCodeException;
        }
        $user = User::where('activation_code', '=', $confirmation_code)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$user) {
            //throw new InvalidConfirmationCodeException;
            return redirect('/login')->with("error_after_loging", "Sorry, this link may be expired or aleady used.");
        }

        $user->is_active = 1;
        $user->activation_code = null;
         $user->save();
        // return $this->loginFbUser('', $user->email_address);
        Auth::loginUsingId($user->user_id);
        return redirect('/myaccount');
        //return redirect('/login')->with("success_singup", "Your account has been verified successfully.");
        //return redirect('/selcurrency')->with("success_singup", "Your account has been verified successfully.");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    /**
     * Logout the specified resource user.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function doLogout() {
        Auth::logout();
        Session::flush();
        $expire = time() - 300;

        setcookie("au_email_address", '', $expire);
        setcookie("au_token", '', $expire);
        return redirect('/login');
    }

    public function webpagecreation() {
        return View('/webpagecreation');
    }

    function getCountryId($ipAddress = "") {
        if ($ipAddress == "") {
            $ipAddress = $this->getIpAddress();
        }
        $countryId = "IND"; //TBD
        // $ipAddress = ip2long("204.147.128.0"); //TBD

        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::join('country', function( $join ) {
                    $join->on('maxmind_ip_pool.iso_country_code', '=', 'country.iso');
                })
                ->selectRaw("country.iso3")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();
        $ispData = $ispData->toArray();
        if (isset($ispData[0]['iso3'])) {
            $countryId = $ispData[0]['iso3'];
        }
        return $countryId;
    }

    public function getDefaultLanguage() {

        return (Session::has("default_language")) ? Session::has("default_language") : 'en';
    }

    function getUtcOffset() {

        $ipAddress = $this->getIpAddress();

        $utcOffset = "+05:30:00"; //TBD
        $ipAddress = ip2long("204.147.128.0"); //TBD
        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::selectRaw("maxmind_ip_pool.utc_offset")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();

        if (isset($ispData[0]->utc_offset)) {
            $utcOffset = $ispData[0]->utc_offset;
        }
        return $utcOffset;
    }

    function getIpAddress() {

        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        }

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
                $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                foreach ($iplist as $ip) {
                    $ip_address = $ip;
                }
            } else {
                $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
            }
        }

        if (!empty($_SERVER['HTTP_X_FORWARDED'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED'];
        } elseif (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_FORWARDED_FOR'];
        } elseif (!empty($_SERVER['HTTP_FORWARDED'])) {
            $ip_address = $_SERVER['HTTP_FORWARDED'];
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }
        return $ip_address;
    }

    public function user_profile() {
		if(!Auth::check()){
			  return View('/login');
		}
        $uid = Session::get('UserEmail');
        $userModel = new \App\User();
        $userData = $userModel::where('email_address', '=', $uid)->first();
		$detect = new MobileDetect();
		$deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        if ($userData->user_id != '') {
            $json_url = url("json-data/get-profile?user_id=" . $userData->user_id);

            $json = file_get_contents($json_url);

            $datav = json_decode($json, true);
            $countryId = $this->getCountryId();

		if ($deviceType == 'computer') {
            return View("/myprofile", ['profiledata' => $datav, 'countryId' => $countryId]);
		}else{
			return View("/mob-myprofile", ['profiledata' => $datav, 'countryId' => $countryId]);
		}
        } else {
            return redirect('/login');
        }
    }

    public function forgotPassSubmit(Request $request) {
        $email = $request->remail_address;

        $validator = Validator::make(
                        array(
                    'remail_address' => $request->remail_address,
                        ), array(
                    'remail_address' => 'required',
                        //'captcha'=>'required|captcha',
                        )
        );

        if ($validator->fails()) {
            return redirect('/login')->withErrors($validator)->withInput();
        } else {
            $userModel = new \App\User();
            $userData = $userModel::where('email_address', '=', $email)->first();
            if (!isset($userData->user_id)) {
                $final_array = array('status' => 0, 'error_mes' => 'Sorry, submitted email address does not exist. Please re-check and submit again.');
                return json_encode($final_array);
                //return redirect('/login')->with("error_login", "Sorry, submitted email address does not exist. Please re-check and submit again.");
            } else {
                if ($userData->user_id != '' && $userData->is_active==1) {
                if ($userData->user_id != '') {
                    $confirmation_code = str_random(30);
                    $userRecoverModel = new \App\Recovers();

                    $userRecoverModel->uid = $userData->user_id;
                    $userRecoverModel->code = $confirmation_code;
                    $userRecoverModel->save();
                    Mail::send('email_forgot', ['confirmation_code' => $confirmation_code, 'usemail' => $email], function($message) use ($email) {
                        //$message->to($email)
                        $message->from('no-reply@vola.ad', 'Reset Account')
                                ->to($email, 'Advertiser')
                                ->subject('Reset Vola.Ad Account ');
                    });
                    $final_array = array('status' => 1, 'error_mes' => 'A mail with the link to reset your password has been sent to your registered email id.');
                    return json_encode($final_array);
                    //return redirect('/login')->with("success_singin", "A mail with the link to reset your password has been sent to your registered email id.");
                } else {
                    $final_array = array('status' => 0, 'error_mes' => 'Sorry, submitted email address does not exist. Please re-check and submit again.');
                    return json_encode($final_array);
                    //return redirect('/login')->with("error_login", "Sorry, submitted email address does not exist. Please re-check and submit again.");
                }

                }else{
                   $final_array = array('status' => 0, 'error_mes' => 'Sorry, submitted email address still not activate. Please check your mail box, we had sent you earlier welcome mail along with activate link. ');
                    return json_encode($final_array);
                }

            }
        }
    }

    public function resetAcc(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;


        if (!$confirmation_code) {
            return redirect('/login')->with("error_signin", "Sorry, please reset password.");
        }
        $recoverModel = new \App\Recovers;
        $user = $recoverModel::where('code', '=', $confirmation_code)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$user) {
            return redirect('/login')->with("error_signin", "Sorry, please reset password.");
        }
        $uid = $user->uid;

        return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code]);
    }

    public function resetAccSubmit(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;

        if (!$confirmation_code) {
            throw new InvalidConfirmationCodeException;
        }

        $recoverModel = new \App\Recovers;
        $user = $recoverModel::where('code', '=', $confirmation_code)->get()->first();
        $recoverid = $user->id;

        //$user = User::whereConfirmationCode($confirmation_code)->first();
        if (isset($user->uid)) {

        } else {

            return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code]);
        }

        $uid = $user->uid;
        $password = $request->password;
        $validator = Validator::make(
                        array(
                    'password' => $request->password,
                    'password_confirmation' => $request->password_confirmation,
                    'secretcd' => $request->secretcd,
                        ), array(
                    'password' => 'required|confirmed|min:6',
                    'secretcd' => 'required',
                        //'captcha'=>'required|captcha',
                        )
        );
        if ($validator->fails()) {
            // return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code])->withErrors($validator)->withInput();
            return view('/reset-account',['secretcd' => $confirmation_code])
                       ->withErrors($validator);
        } else {
            $cnfpassword = $request->password_confirmation;
            if ($password != $cnfpassword) {
                return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code])->withErrors($validator)->withInput();
            } else {

                $uModel = \App\User::find($uid);
                $uModel->password = Hash::make($password);

                $uModel->save();


                $urModel = \App\Recovers::find($recoverid);
                $urModel->delete();
                Auth::loginUsingId($uModel->user_id);
                // $this->loginFbUser('', $uModel->email_address);
                return redirect('/myaccount')->with("success_ad", "Congrats! Your password has been reset successfully. ");
            }
        }
    }

    public function getCurrencyFromAccount($account_id) {

        $data = Advertiser::where('dl_advertisers.account_id', $account_id)
                        ->leftJoin('currency_database', 'currency_database.symbol', '=', 'dl_advertisers.currency')
                        ->selectRaw('currency_database.symbol')
                        ->take(1)->get();
        return ($data[0]->symbol) ? $data[0]->symbol : 'INR';
    }

    /**
     * Obtain the user information from Facebook.
     *
     * @return Response
     */
    public function handleProviderFbCallback(Request $request) {
        if($request->ajax()){
         $authUser = $this->findOrCreateUser($request);
         return $authUser;
        }
    }

    /**
     * Return user if exists; create and return if doesn't
     *
     * @param $facebookUser
     * @return User
     */
    private function findOrCreateUser($facebookUser) {


        $authUser = User::where('email_address', $facebookUser->email)->first();

        if ($authUser) {
            // $this->loginFbUser($facebookUser->id, $facebookUser->email);
            // $authUser->update(['facebook_id' => $facebookUser->id]);
            User::where('user_id', $authUser['attributes']['user_id'])->update(['facebook_id' => $facebookUser->id]);
            Auth::loginUsingId($authUser['attributes']['user_id']);
            return 'Authenticated';

        } else {
            $requestDtArr = array('email_address' => $facebookUser->email, 'facebook_id' => $facebookUser->id);
            return  $this->create_fbuser($requestDtArr);
        }




        /* return User::create([
          'name' => $facebookUser->name,
          'email' => $facebookUser->email,
          'facebook_id' => $facebookUser->id,
          'avatar' => $facebookUser->avatar
          ]); */
    }

    /**
     * Show the form for login fb users.
     * This function is use for the a fb user in login process
     * @return \Illuminate\Http\Response
     */
    public function loginFbUser($fbid, $fbemail) {

        if (Auth::attempt(['email_address' => $fbemail])) {
            $user = Auth::User();
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;

                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;

                    if (!empty($user->country_id)) {
                        $sessdata['country_id'] = $user->country_id;
                    } else {
                        $sessdata['country_id'] = $this->getCountryId();
                    }
                    if (empty($user->user_timezone)) {
                        $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                ->get()
                                ->first();
                        $sessdata['user_timezone'] = $tz_data->zone_name;
                    } else {
                        $sessdata['user_timezone'] = $user->user_timezone;
                    }

                    switch ($accounts->account_type) {
                        case 'ADVERTISER':
                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            break;
                        case 'PUBLISHER':
                            break;
                        case 'MANAGER':
                            break;
                        case 'ADMIN':
                            break;
                    }
                    $count++;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
                if (trim($user->facebook_id) == '') {

                    User::where('user_id', $user->user_id)->update(['facebook_id' => $fbid]);
                }
            }

            return redirect('/myaccount');
        } else {

            return redirect('/login')->with('error_login', 'Sorry, your account is not exist.');
        }
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_fbuser($requestDt) { // create advertiser
        //print_r($request->all());
        //die();
        if (trim($requestDt['email_address']) == '') {
            // return redirect('/login')->with("error", "Unable to login using Facebook account - please change the privacy settings. Or sign up using your emil addresss or mobile number. ");
              return 'Unable_to_Login_Privacy_Issues';
        }
        $email = $requestDt['email_address'];
        $characters = 'abcdefghjkmnpqrstuvwxyz23456789';
        $stringpwd = '';
        for ($i = 0; $i < 8; $i++) {
            $stringpwd .= $characters[rand(0, strlen($characters) - 1)];
        }

        $password = $stringpwd;
        // $password = $request->password_confirmation;
        //$phone = $request->phone_number;
        $fbid = $requestDt['facebook_id'];

        $data = array(
            "email_address" => $email,
            "password" => Hash::make($password),
            "is_active" => 1,
            "facebook_id" => $fbid
        );


        /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;

            //$data['utc_offset'] = $this->getUtcOffset();
            $data['country_id'] = $this->getCountryId();
            $data['created_at'] = date('Y-m-d H:i:s');
            //$data['default_language'] = $this->getDefaultLanguage();

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                    'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'], 'status' => 1, 'create_date_time' => date('Y-m-d H:i:s')));
                DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));

                Mail::send('email_welcome', ['pwds' => $stringpwd, 'email' => $email], function($message) use ($email) {
                    //$message->to($email)
                    $message->from('no-reply@audiencenest.com', 'Verify')
                            ->to($email, 'Advertiser')
                            ->subject('Welcome to Vola.ad - Your Account has been created successfully.');
                });

                 Auth::loginUsingId($this->user_id);
                //  $authUser->update(['facebook_id' => $facebookUser->id]);
                return 'Authenticated';
            }
        }
        //return redirect('/login')->with("error_after_loging", "Not Insert");
    }

    /**
     * Obtain the user information from Google.
     *
     * @return Response
     */
    public function handleProviderGoogleCallback(Request $request) {
        // try {
        //     $user = Socialite::driver('google')->user();
        // } catch (\Exception $e) {
        //     return redirect('/login')->with("error_login", "Invalid request.");
        // }
        // if (isset($request->error) && trim($request->error) != '') {
        //     return redirect('/login')->with("error_login", "Invalid request.");
        // }

        $authUser = $this->findOrCreateUserGoogle($request);

        //$this->login($authUser, true);
        //return redirect()->route('home');
        // return redirect('/myaccount');
        return   $authUser;

    }

    private function findOrCreateUserGoogle($googleUser) {
      // dd($googleUser->all());
        $authUser = User::where('email_address', $googleUser->email)->first();

        if ($authUser) {
            // $this->loginGpUser($googleUser->id, $googleUser->email);
            User::where('user_id', $authUser['attributes']['user_id'])->update(['google_id' => $googleUser->id]);
            Auth::loginUsingId($authUser['attributes']['user_id']);
            return 'Authenticated';
        } else {
            $requestDtArr = array('email_address' => $googleUser->email, 'google_id' => $googleUser->id);
            return $this->create_gpuser($requestDtArr);
        }
    }

    /**
     * Show the form for login Google Plus users.
     * This function is use for the a Google Plus user in login process
     * @return \Illuminate\Http\Response
     */
    public function loginGpUser($gpid, $gpemail) {

        if (Auth::attempt(['email_address' => $gpemail])) {
            $user = Auth::User();
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;

                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;

                    if (!empty($user->country_id)) {
                        $sessdata['country_id'] = $user->country_id;
                    } else {
                        $sessdata['country_id'] = $this->getCountryId();
                    }
                    if (empty($user->user_timezone)) {
                        $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                ->get()
                                ->first();
                        $sessdata['user_timezone'] = $tz_data->zone_name;
                    } else {
                        $sessdata['user_timezone'] = $user->user_timezone;
                    }

                    switch ($accounts->account_type) {
                        case 'ADVERTISER':
                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            break;
                        case 'PUBLISHER':
                            break;
                        case 'MANAGER':
                            break;
                        case 'ADMIN':
                            break;
                    }
                    $count++;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
                if (trim($user->google_id) == '') {
                    User::where('user_id', $user->user_id)->update(['google_id' => $gpid]);
                }
            }


            return redirect('/myaccount');
        } else {

            return redirect('/login')->with('error_login', 'Sorry, your account is not exist.');
        }
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user from google in singup
     * @return \Illuminate\Http\Response
     */
    public function create_gpuser($requestDt) { // create advertiser
        //print_r($request->all());
        //die();
        $email = $requestDt['email_address'];
        $characters = 'abcdefghjkmnpqrstuvwxyz23456789';
        $stringpwd = '';
        for ($i = 0; $i < 8; $i++) {
            $stringpwd .= $characters[rand(0, strlen($characters) - 1)];
        }

        $password = $stringpwd;
        // $password = $request->password_confirmation;
        //$phone = $request->phone_number;
        $googleid = $requestDt['google_id'];

        $data = array(
            "email_address" => $email,
            "password" => Hash::make($password),
            "is_active" => 1,
            "google_id" => $googleid
        );


        /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;

            //$data['utc_offset'] = $this->getUtcOffset();

            $data['country_id'] = $this->getCountryId();
            $data['created_at'] = date('Y-m-d H:i:s');
            //$data['default_language'] = $this->getDefaultLanguage();

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                    'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'], 'status' => 1, 'create_date_time' => date('Y-m-d H:i:s')));
                DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));

                Mail::send('email_welcome', ['pwds' => $stringpwd, 'email' => $email], function($message) use ($email) {
                    //$message->to($email)
                    $message->from('no-reply@audiencenest.com', 'Verify')
                            ->to($email, 'Advertiser')
                            ->subject('Welcome to Vola.ad - Your Account has been created successfully.');
                });

                Auth::loginUsingId($this->user_id);
                return 'Authenticated';
                // $this->loginGpUser($fbid, $email);
            }
        }
        //return redirect('/login')->with("error_after_loging", "Not Insert");
    }



    public function notification_emails()
    {
       $userJson = DB::table('cf_users')->where('notify_me_json','!=',"")->pluck('notify_me_json','default_account_id');
       foreach ($userJson as $key => $value) {
         foreach (json_decode($value, true) as $key1 => $d_value) {
                    if($d_value != "0")
                    {
                      $this->sendEmailNotifications($key,$key1,$d_value);
                    }
         }
       }
    }

    public function sendEmailNotifications($user_id,$jsonmsg,$bool_value){
      $user = DB::table('dl_advertisers')->where('account_id',$user_id)->first();
      $advertiser_id=$user->advertiser_id;
      switch($jsonmsg)
      {
        case "out_of_fund" :
          if($user->balance_left_currency == 0){
            $email=$user->contact_email;
            Mail::send('emails.outOfFundMail' ,[$email] ,function($message) use ($email) {
                $message->from('no-reply@audiencenest.com', 'Out of Balance')
                        ->to($email, 'Advertiser')
                        ->subject('Out of Funds ');
            });

          }
            break;
        case "less_amount" :
          if($user->balance_left_currency < $bool_value){

            $email=$user->contact_email;
            Mail::send('emails.lessamountMail' ,[$email, 'amount'=> $bool_value] ,function($message) use ($email,$bool_value) {
                $message->from('no-reply@audiencenest.com', 'Low Balance')
                        ->to($email, 'Advertiser')
                        ->subject('Low Balance ');
            });
          }
            break;
        case "long_paused" :
            break;
        case "refresh_picture" :
            break;
        case "approve_rejected" :
            break;
        case "report_duration" :
            if($bool_value == 'd')
            {
              $ad_report=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)->count();
              $running_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                   ->where('status','running')->count();
              $pau_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                  ->where('status','pause')->count();
              $email=$user->contact_email;
              $bal_left=$user->balance_left_currency;
              Mail::send('emails.reportmail' ,[$email,'publised_ad'=> $ad_report, 'pause_ad'=> $pau_ad ,'running_ad' => $running_ad ,'bal_left' => $bal_left ] ,function($message) use ($email) {
                  $message->from('no-reply@audiencenest.com', 'Reports')
                          ->to($email, 'Advertiser')
                          ->subject('Reports');
              });
            }

            break;
        default:
      }
    }

    public function notification_emails_weekly()
    {
      $userJson = DB::table('cf_users')->where('notify_me_json','!=',"")->pluck('notify_me_json','default_account_id');
      foreach ($userJson as $key => $value) {
        foreach (json_decode($value, true) as $key1 => $d_value) {
                   if($d_value != "0")
                   {
                     $this->sendemail_weekly($key,$key1,$d_value);
                   }
        }
      }
    }

    public function sendemail_weekly($user_id,$jsonmsg,$bool_value)
    {

        $user = DB::table('dl_advertisers')->where('account_id',$user_id)->first();
        $advertiser_id=$user->advertiser_id;
        switch($jsonmsg)
        {
          case "report_duration" :
              if($bool_value == 'w')
              {
                $ad_report=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)->count();
                $running_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                     ->where('status','running')->count();
                $pau_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                    ->where('status','pause')->count();
                $email=$user->contact_email;
                $bal_left=$user->balance_left_currency;
                Mail::send('emails.reportmail' ,[$email,'publised_ad'=> $ad_report, 'pause_ad'=> $pau_ad ,'running_ad' => $running_ad ,'bal_left' => $bal_left ] ,function($message) use ($email) {
                    $message->from('no-reply@audiencenest.com', 'Reports')
                            ->to($email, 'Advertiser')
                            ->subject('Reports');
                });
              }

              break;
          default:
        }
    }

    public function notification_emails_monthly()
    {
      $userJson = DB::table('cf_users')->where('notify_me_json','!=',"")->pluck('notify_me_json','default_account_id');
      foreach ($userJson as $key => $value) {
        foreach (json_decode($value, true) as $key1 => $d_value) {
                   if($d_value != "0")
                   {
                     $this->sendemail_monthly($key,$key1,$d_value);
                   }
        }
      }
    }

    public function sendemail_monthly($user_id,$jsonmsg,$bool_value)
    {

        $user = DB::table('dl_advertisers')->where('account_id',$user_id)->first();
        $advertiser_id=$user->advertiser_id;
        switch($jsonmsg)
        {
          case "report_duration" :
              if($bool_value == 'm')
              {
                $ad_report=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)->count();
                $running_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                     ->where('status','running')->count();
                $pau_ad=DB::table('dl_campaigns')->where('advertiser_id',$advertiser_id)
                                                    ->where('status','pause')->count();

                $email=$user->contact_email;
                $bal_left=$user->balance_left_currency;
                Mail::send('emails.reportmail' ,[$email,'publised_ad'=> $ad_report, 'pause_ad'=> $pau_ad ,'running_ad' => $running_ad ,'bal_left' => $bal_left ] ,function($message) use ($email) {
                    $message->from('no-reply@audiencenest.com', 'Reports')
                            ->to($email, 'Advertiser')
                            ->subject('Reports');
                });
              }

              break;
          default:
        }
    }

    public function subscribe(Request $request)
    {

     $sub = new \App\Subscribe();
     $sub->email= $request->email;
     $sub->save();
      return redirect('/');
    }

}
