<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\QueryAccess;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Auth;
use App\IpPools;
use Illuminate\Support\Facades\Redis;
use Cache;
use Log;


class IpPoolsController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        $select =  [
            "id",
            "name",
            "ip_pools",
            "created", 
            "updated", 
         ];
        $condtion = [];
        
        $data =  IpPools::all();
         $data1= [];
         $count = 0;
          foreach ($data as $result) {
                $array = [];
                $count++;
                $action = '<a href="/ip-pools/edit/'.$result->id.'">Edit</a>|<a href="/ip-pools/delete/'.$result->id.'">Delete</a>';
                array_push($array,
                            $result->id,
                            $result->name,
                            $result->ip_pools,
                            $result->created,
                            $result->updated,
                            $action
                          );
                  array_push($data1, $array);
          }
          return view('ippools.index',compact('data1'));
      }
    
    public function add(Request $request){
        return view('ippools.add',['errors'=>'']);  
    }
    
    public function store(Request $request){
      $created = date('Y-m-d H:i:s');
      $validate = $this->validate($request,[
          'name' => 'required|unique:ip_pools|max:275',
          'ip_pools' => 'required',
          ]);
     if($validate->fails()){
        return Redirect::back()->withErrors($validate);
      }
      // print_r($validate);die;
      IpPools::create(
            [
              'ip_pools' => $request->ip_pools,
              'name' => $request->name,
              'created' => $created
            ]
            );
      return redirect('ip-pools');  
    }

    public function edit($id){
      $IpPools = IpPools::find($id);
      $error = '';
      return view('ippools.edit',compact('IpPools','error'));
    }



    public function update(Request $request){
       $validate = $this->validate($request,[
          'name' => 'required',
          'ip_pools' => 'required',
        ]);
       $created = date('Y-m-d H:i:s');
       $IpPools = IpPools::find($request->id);
       if($request->id){
           $IpPools->name = $request->name;
           $IpPools->ip_pools = $request->ip_pools;
           $IpPools->save();
        }
        return redirect('ip-pools');  
    }

    public function destroy($id){
        IpPools::destroy($id);
        return redirect()->route('ipPools')
                        ->with('success','Deleted successfully');
    }

}
