<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Auth;
use Session;


abstract class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    public function sessionRefresh()
    {
      $user = Auth::User();
      if ($user) {
          $sessdata = array();
          $sessdata['country_id'] = $user->country_id;
          $count = 0;
          foreach ($user->roles as $role) {
              $sessdata['roles'][$count]['role_id'] = $role->id;
              $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
              $count++;
          }
          $count = 0;
          foreach ($user->accounts as $accounts) {
              $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
              $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
              switch ($accounts->account_type) {
                  case 'ADVERTISER':
                      $advertiser = $accounts->advertiser;
                      $advertiser = $advertiser->toArray();
                      $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                      $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                      if (!empty($user->country_id)) {
                          $sessdata['country_id'] = $user->country_id;
                      } else {
                          $sessdata['country_id'] = $this->getCountryId();
                      }
                      if (empty($user->user_timezone)) {
                          $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                  ->get()
                                  ->first();
                          $sessdata['user_timezone'] = $tz_data->zone_name;
                      } else {
                          $sessdata['user_timezone'] = $user->user_timezone;
                      }

                      break;
                  case 'PUBLISHER':
                      break;
                  case 'MANAGER':
                      break;
                  case 'ADMIN':
                      break;
              }
              $count++;
          }
          Session::put('UserID', $user->user_id);
          Session::put('UserEmail', $user->email_address);
          Session::put('sessiondata', $sessdata);
      }

    }
    function getCountryId($ipAddress = "") {
        if ($ipAddress == "") {
            $ipAddress = $this->getIpAddress();
        }
        $countryId = "IND"; //TBD
        // $ipAddress = ip2long("204.147.128.0"); //TBD

        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::join('country', function( $join ) {
                    $join->on('maxmind_ip_pool.iso_country_code', '=', 'country.iso');
                })
                ->selectRaw("country.iso3")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();
        $ispData = $ispData->toArray();
        if (isset($ispData[0]['iso3'])) {
            $countryId = $ispData[0]['iso3'];
        }
        return $countryId;
    }

    function getIpAddress() {

        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        }

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
                $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                foreach ($iplist as $ip) {
                    $ip_address = $ip;
                }
            } else {
                $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
            }
        }

        if (!empty($_SERVER['HTTP_X_FORWARDED'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED'];
        } elseif (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_FORWARDED_FOR'];
        } elseif (!empty($_SERVER['HTTP_FORWARDED'])) {
            $ip_address = $_SERVER['HTTP_FORWARDED'];
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }
        return $ip_address;
    }
}
