<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\AuditingTrait;

class Advertiser extends Model {

    /**
     * The database table used by the model.
     * @var string
     */
    use AuditingTrait;
    protected $auditEnabled = true;
    protected $table = 'dl_advertisers';
    protected $primaryKey = 'advertiser_id';
    protected $fillable = ['advertiser_id', 'account_id','company','contact_name','billing_address','billing_city','billing_state', 'billing_country','billing_pin_code','billing_contact_email','billing_contact_name','billing_phone'];
    public $timestamps = false;

    /*
      |--------------------------------------------------------------------------
      | Relationship Methods
      |--------------------------------------------------------------------------
     */

    /**
     * many-to-many relationship method.
     *
     * @return QueryBuilder
     */
    public function users() {
        return $this->belongsToMany('\App\User', 'account_user', 'account_id', 'user_id');
    }

    public function account() {
        return $this->belongsTo('\App\Account', 'account_id');
    }

    public function Campaigns() {
        return $this->hasMany('\App\Campaigns', 'advertiser_id');
    }

    public function paymenthistory(){

         return $this->belongsTo('\App\PaymentTransaction', 'account_id');
    }

    public function AccountUserlist(){
        return $this->belongsTo('\App\AccountUser','account_id');
    }


}
